#!/usr/bin/perl

use strict;
use warnings;

use Jellybean::App;
use File::Spec::Functions;

# Fill these in:
#	- path to the database to use (set it somehow for the Maypole app)
#	- path to web files to serve
#	- path to application templates
#	- name of the Maypole module to run
#	- URI path to the Handler containing the Maypole app

my $db_name    = shift || $ENV{DB} || '';
my $webfiles   = '';
my $templates  = '';
my $app_module = '';
my $uri_base   = '';

# fake out Maypole 1.5 and older, since this Jellybean is mod_perl enough
BEGIN
{
	$INC{'Apache.pm'}         = 1;
	$INC{'Apache/Request.pm'} = 1;
}

my $app  = Jellybean::App->new(
	HTTP =>
	{
		LocalPort => 5000
	},
	handlers =>
	{
		default =>
		{
			type    => 'File',
			basedir => $webfiles,
		},
		$app_module =>
		{
			type      => 'Maypole',
			app       => $app_module,
			uri_base  => $uri_base,
			templates => $templates,
		},
	}
);

$app->loop();
