#!/usr/bin/perl -w

BEGIN
{
	chdir 't' if -d 't';
	use lib '../lib', '../blib/lib', 'lib';
}

use strict;

use Test::More tests => 27;

use Test::Exception;
use Test::MockObject;

my $module = 'Jellybean::Handler::Maypole';
use_ok( $module ) or exit;

ok( $module->does( 'Jellybean::Handler' ),
	"$module should perform Jellybean::Handler role" );

diag( 'Testing Jellybean::Handler::Maypole' );

can_ok( $module, 'new' );

throws_ok { $module->new() } qr/No Maypole app class provided/,
	'new() should die without app module named';

throws_ok { $module->new( app => 'unknown_module' ) } qr/Couldn't require/,
	'... or if it cannot load Maypole app module';

my $jcm = $module->new(
	app           => 'MaypoleReq',
	template_root => 'templates',
	uri_base      => 'uri',
);

ok( MaypoleReq->does( 'Jellybean::Handler::Roles::Maypole' ),
	'new() should apply appropriate role to loaded app module' );

isa_ok( $jcm, $module );

can_ok( $module, 'formatter_type' );
is( $jcm->formatter_type(), (), 'formatter_type() should return nothing' );

can_ok( $module, 'app' );
is( $jcm->app(), 'MaypoleReq', 'app() should return loaded app type' );

can_ok( $module, 'activate' );
$jcm->activate( 'test_in', 'test_out' );

my $handled = MaypoleReq->handled();
is( @$handled, 1, 'activate() should call handle() on app module' );
is_deeply( $handled->[0], { _request => 'test_in', _response => 'test_out' },
	'... and should set request and response objects in configuration' );
ok( ! exists MaypoleReq->config->{jb}, '... deleting them at the end' );
is( MaypoleReq->config->{uri_base}, 'uri',
	'... setting uri_base appropriately' );

$jcm->{uri_base} = 'new_uri';
$jcm->activate( 'test_in', 'test_out' );
is( MaypoleReq->config->{uri_base}, 'new_uri',
	'... for each request' );

diag( 'Testing Jellybean::Handler::Roles::Maypole' );
# testing it indirectly, though

$module = 'MaypoleReq';

can_ok( $module, 'get_request'    );
is( $module->get_request(), (), 'get_request() should return nothing' );

my $mock_out = Test::MockObject->new->set_true( 'body' );
my $mock_in  = Test::MockObject->new
	->mock(       path   => sub { qw( path to here )} )
	->set_always( params => 'my params' );

can_ok( $module, 'send_output'    );

my $mr = bless { output => 'out' }, $module;
$mr->config->{jb} =
{	
	_request  => $mock_in,
	_response => $mock_out,
};
$mr->send_output();

my ($method, $args) = $mock_out->next_call();
is( $method,    'body', 'send_output() should set response body' );
is( $args->[1],  'out', '... output set in object' );

can_ok( $module, 'parse_location' );
$mr->parse_location();
is( $mr->{path}, 'path/to/here',
	'parse_location() should set stringified path from request object' );

for my $field (qw( params query ))
{
	is_deeply( $mr->{$field}, 'my params',
		"... setting $field field to params from request" );
}

is( $mr->{parse_path}, 1, '... calling parse_path() on object' );
